/*------------------------------------------------------------------------------*
 * File Name: EasyLR.h		 													*
 * Creation: GJL 7/17/03														*
 * Purpose: OriginC header file containing implementation of EasyLR class.		*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007				*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/

#ifndef _EASY_LR_H
#define _EASY_LR_H

class EasyLR : public EasyFit
{
	public:
		// Constructors
		EasyLR():EasyFit() {}
		EasyLR(Curve& crvOriginal):EasyFit(crvOriginal) {}
		EasyLR(LPCSTR lpcszYData):EasyFit(lpcszYData) {}
		EasyLR(LPCSTR lpcszXData, LPCSTR lpcszYData):EasyFit(lpcszXData, lpcszYData) {}
		EasyLR(Dataset& dsX, Dataset dsY):EasyFit(dsX, dsY) {}
		EasyLR(Worksheet& wks, int nColX, int nColY):EasyFit(wks, nColX, nColY) {}
		EasyLR(Worksheet& wks, int nColY):EasyFit(wks, nColY) {}
		EasyLR(DataPlot& dp):EasyFit(dp) {}
		EasyLR(curvebase& crv, int& nNumMissingInCopy, int& nSrcOffset, DWORD dwOptions = 0,
			int nLower = -1, int nUpper = -1)
				:EasyFit(crv, nNumMissingInCopy, nSrcOffset, dwOptions, nLower, nUpper) {}

		// Destructor
		~EasyLR() {}

		// Virtual Methods
		virtual BOOL Fit();
		virtual BOOL Init(Curve& crv);
};

// Virtual Method
// Initialize settings and input curve
BOOL EasyLR::Init(Curve& crv)
{
	Tree trTemp;

	trTemp.GUI.Fit.ThroughZero.nVal = 0;               // Force fit to pass thru zero
	trTemp.GUI.Fit.FixSlope.nVal = 0;                  // Force slope to be fixed
	trTemp.GUI.Fit.FixSlopeAt.dVal = 1;                // Fixed value of slope (Note: cannot fix slope and thru zero at same time, should return error from LLOC)
	trTemp.GUI.Fit.ErrBarWeight.nVal = 0;              // Use error column for wt - use (1/err^2) as wt factor
	trTemp.GUI.Fit.UseReducedChiSq.nVal= 0;            // Scale parameter errors with reduced chisqr

	trTemp.GUI.ResultCurves.Points.nVal = 60;          // Number of points in fit curve
	trTemp.GUI.ResultCurves.ConfBands.nVal = 0;        // Create confidence bands - if not set, then matrix will have empty columns
	trTemp.GUI.ResultCurves.PredBands.nVal = 0;        // Create prediction bands - if not set, then matrix will have empty columns
	trTemp.GUI.ResultCurves.Confidence.dVal = 95;      // Confidence value to be used 

	trTemp.Calculation.Control.UseDataXRange.nVal = 1; // Option = 1 to use data range, = 0 to use X1, X2
	trTemp.Calculation.Control.X1.dVal = NANUM;        // Default X minimum for fit curve
	trTemp.Calculation.Control.X2.dVal = NANUM;        // Default X maximum for fit curve

	m_trWhole.AddNode(trTemp.GUI.Clone());
	m_trWhole.AddNode(trTemp.Calculation.Clone());

	return EasyFit::Init(crv);
}

// Virtual Method
// Customize settings, perform fit, and create output curve in hidden worksheet
BOOL EasyLR::Fit()
{
	matrix mResultCurves;

	// Customize Settings
	if( Settings.ThroughZero.IsValid() )
		m_trWhole.GUI.Fit.ThroughZero.nVal = Settings.ThroughZero.nVal;

	if( Settings.FixSlope.IsValid() )
		m_trWhole.GUI.Fit.FixSlope.nVal = Settings.FixSlope.nVal;

	if( Settings.FixSlopeAt.IsValid() )
		m_trWhole.GUI.Fit.FixSlopeAt.dVal = Settings.FixSlopeAt.dVal;

	if( Settings.UseReducedChiSq.IsValid() )	
		m_trWhole.GUI.Fit.UseReducedChiSq.nVal = Settings.UseReducedChiSq.nVal;

	if( Settings.Points.IsValid() )
		m_trWhole.GUI.ResultCurves.Points.nVal = Settings.Points.nVal;

	if( Settings.Confidence.IsValid() )
		m_trWhole.GUI.ResultCurves.Confidence.dVal = Settings.Confidence.dVal;

	if( Settings.UseDataXRange.IsValid() )
		m_trWhole.Calculation.Control.UseDataXRange.nVal = Settings.UseDataXRange.nVal;

	if( Settings.X1.IsValid() )	
		m_trWhole.Calculation.Control.X1.dVal = Settings.X1.dVal;

	if( Settings.X2.IsValid() )	
		m_trWhole.Calculation.Control.X2.dVal = Settings.X2.dVal;

	// Perform fit and create output curve in hidden worksheet
	if( ERROR_NO_ERROR == stat_linear_fit(m_crvInput, mResultCurves, m_trWhole) )
		return CreateOutputCurve(mResultCurves);
	else
		return FALSE;
}

// Methods
//BOOL Attach(LPCSTR lpcszYData) {return m_crvInput.Attach(lpcszYData);}
//BOOL Attach(LPCSTR lpcszXData, LPCSTR lpcszYData) {return m_crvInput.Attach(lpcszXData, lpcszYData);}

#endif // _EASY_LR_H	